﻿using System;

namespace sample {
	class Program {
		Boolean OleErrCallback(DMC.OleErr oleErr) {
			System.Console.Out.WriteLine("OleErr level " + oleErr.LevNum.ToString() + ", code " + oleErr.ErrCode.ToString() + ", engine " + oleErr.DtctResult);
			return true;
		}

		void Proc(string[] args) {
			if (args.Length < 2) {
				Console.Out.WriteLine("usage: sample appFile txtFile");
				return;
			}
			var textInfo = new DMC.TextInfoV5();
			textInfo.DefLangName = DMC.TextInfoV5.JAPANESE;
			var fileInfo = new DMC.FileInfo();
			var result = DMC.TextPorterV5.GetFileInfo_V5(args[0], fileInfo, textInfo);
			Console.Out.WriteLine(result);
			Console.Out.WriteLine(fileInfo.DocFormat);
			//
			var prop = new DMC.Property();
			result = DMC.TextPorterV5.GetProperty_V5(args[0], textInfo, prop);
			System.Console.Out.WriteLine(prop.author);
			System.Console.Out.WriteLine(prop.presentation);
			System.Console.Out.WriteLine(prop.title);
			//
			textInfo.GroupName = DMC.TextInfoV5.UTF8;
			textInfo.Option = DMC.TextInfoV5.DMC_GETTEXT_OPT_OLE | DMC.TextInfoV5.DMC_GETTEXT_OPT_OLE2 | DMC.TextInfoV5.DMC_GETTEXT_OPT_OLE3;
			//result = DMC.TextPorterV5.GetText_V5W(args[0], args[1], textInfo);
			result = DMC.TextPorterV5.GetText_V5(args[0], args[1], textInfo, new DMC.OleErrCallbackDelegate(OleErrCallback));
			//int pages = 1;
			//result = DMC.TextPorterV5.GetPageText_V5(args[0], args[1], textInfo, ref pages);
			//result = DMC.TextPorterV5.GetPageText_V5(args[0], args[1], textInfo, ref pages, new DMC.OleErrCallbackDelegate(OleErrCallback));
			System.Console.Out.WriteLine(result);
		}

		static void Main(string[] args) {
			new Program().Proc(args);
		}
	}
}
