/*
 * .NETC++̃Xg[тXg[ubW
 * 2016.07.18 Takeshi Yoneki
 */

#include "dmcdotnetstream.h"

using namespace System;
using namespace System::IO;
using namespace System::Runtime::InteropServices;

DMCDOTNETStreamBuf::DMCDOTNETStreamBuf(void *paramAsStream) {
	memset(data, 0, sizeof(char) * DMCDOTNETStream_BUFSIZE);
	setp(data, data + DMCDOTNETStream_BUFSIZE - 1);
	dotnetStream = (Stream^)Marshal::GetTypedObjectForIUnknown((IntPtr)paramAsStream, Stream::typeid);
}

DMCDOTNETStreamBuf::~DMCDOTNETStreamBuf(void) {
	sync();
}

std::ios::int_type DMCDOTNETStreamBuf::overflow(int_type c) {
	return (outputProc() < 0) ? traits_type::eof() : sputc(c);
}

int DMCDOTNETStreamBuf::sync() {
	return outputProc();
}

int DMCDOTNETStreamBuf::outputProc() {	
	int count = (int)(pptr() - pbase());
	if (count > 0) {
		array<unsigned char>^ buffer = gcnew array<unsigned char>(count);
		for (int i = 0; i < count; i++) {
			buffer[i] = data[i];
		}
		dotnetStream->Write(buffer, 0, count);
		pbump(-count);
	}
	return 0;
}

DMCDOTNETStreamBridge::DMCDOTNETStreamBridge(void *paramAsStream) :
	streamBuf(paramAsStream),
	std::basic_ostream<char>(&streamBuf) {
}

DMCDOTNETStreamBridge::~DMCDOTNETStreamBridge() {
}
