/*
 * Copyright (C) 1999 AntennaHouse Inc.  All Rights Reserved
 */

/*----------------------------------
   TITLE:DMC_CONF.C
   PRODUCT:DMC Product
   Comment:Char Convert
   ------------------------------------*/
/*
 * Author:Hiromi Mikoshiba
 *
 * 1999/04/16 Start.
 */

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */

#ifdef TAGEDITOR
#include  <windows.h>
#include  <winioctl.h>
#include  <mbstring.h>
#include  <stdio.h>
//#include "windows.h"
#endif

#include <stdlib.h>
#include <string.h>	/* 99.08.13 by Lin */

//#include "dmcbase.h"
#include "text_oem.h"

/******************************************************************************
 * 
 *****************************************************************************/
int dmc_GetKeyValue(char *key, char *value, int nbyte)
{
	if (strcmp("Charsetpath", key)==0 || strcmp("Licensepath", key)==0)
	{


#ifdef TAGEDITOR
		char tzSoftware[] = "Software";
		char tzAntenna[]  = "AntennaHouse";
		char tzTagme[]    = "TagEditor";
		char tzVersion[]  = "2.0";
		char tzData[]     = "data";
		char strValue[260];

// for TagEditorV2.1 2000.4.24 by T.Mayumi
		HINSTANCE	hDll;
		FARPROC lpfnDllFunc1;    // Function pointer
		struct	{
			char	path[128];
		}DataPath;
		int	iRet;
		char *p;

		memset(strValue, 0, sizeof(strValue));

		iRet = FALSE;
		hDll = LoadLibrary("RegConf.DLL");
		if( hDll != NULL ){
			lpfnDllFunc1 = GetProcAddress(hDll,
                                           "GetDataConfig");
			if (!lpfnDllFunc1){
			// handle the error
				FreeLibrary(hDll);       
			}else{
				// call the function
				iRet = lpfnDllFunc1(&DataPath);
				if( iRet == TRUE ){
					strcpy(strValue,DataPath.path);
				}
				FreeLibrary(hDll); 
			}
		}
////////////////////////////////////////  V2.1 ///////////
		if( iRet != TRUE ){			  //  V2.0 //////////

		{
			HKEY hSoftware = NULL;
			if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, tzSoftware,
				0, KEY_READ,
				&hSoftware) == ERROR_SUCCESS)
			{
				HKEY hAntenna = NULL;
				if (RegOpenKeyEx(hSoftware, tzAntenna,
					0, KEY_READ,
					&hAntenna) == ERROR_SUCCESS)
				{
					HKEY hTagme = NULL; 
					if (RegOpenKeyEx(hAntenna, tzTagme,
						0, KEY_READ,
						&hTagme) == ERROR_SUCCESS)
					{
						HKEY hVersion = NULL; 
						if (RegOpenKeyEx(hTagme, tzVersion,
							0, KEY_READ,
							&hVersion) == ERROR_SUCCESS)
						{
							HKEY hData = NULL; 
							if (RegOpenKeyEx(hVersion, tzData,
								0, KEY_READ,
								&hData) == ERROR_SUCCESS)
							{
								DWORD dwType = REG_SZ;
								DWORD dwCount = sizeof(strValue);
								RegQueryValueEx(hData, NULL,
									NULL, &dwType, strValue, &dwCount);
								RegCloseKey(hData);
							}
							RegCloseKey(hVersion);
						}
						RegCloseKey(hTagme);
					}
					RegCloseKey(hAntenna);
				}
				RegCloseKey(hSoftware);
			}
		}
		}
// 2000.4.24 By T.Mayumi
		p =  strrchr(strValue,'\\');
		if( p != NULL ){
			if( strlen(p) != 1){
				strcat(strValue,"\\");
			}
		}
////		

		strncpy(value, strValue, nbyte);
#else
#ifdef DMC_WIN
//		char def_val[] ="c:\\data\\base2\\";
		char def_val[] ="base2\\";
#endif
#ifdef DMC_SOLARIS
//		char def_val[] ="/export/home/antenna/dmc1/base2/";
		char def_val[] ="base2/";
#endif
#ifdef DMC_LINUX
//		char def_val[] ="/export/antenna/dmc-test/work/data/base2/";
		char def_val[] ="base2/";
#endif
#ifdef DMC_AIX
//		char def_val[] ="/export/antenna/dmc-test/work/data/base2/";
		char def_val[] ="base2/";
#endif
/* Mac OS X (Core Darwin) */
#ifdef DMC_MACOSX
		char def_val[] ="base2/";
#endif
#ifdef DMC_HPUX
		char def_val[] ="base2/";
#endif
		char *path;
		path = getenv("DMC_TBLPATH");
		if (path == NULL) {
			path = def_val;
		}
		if ((int)strlen(path) > nbyte){
			return 0;
		}
		strncpy(value,path,nbyte);
#endif
		return strlen(value);
	}
	return 0;
}

#ifdef __cplusplus
}
#endif  /* __cplusplus */





