/*
 * .NETlCeBuC^[tF[X
 * Copyright (C) 2015-2021 AntennaHouse Inc.  All Rights Reserved
 * 2015-2021 Takeshi Yoneki
 */

#ifdef _WINDOWS
#include <windows.h>
#endif
#include <stdlib.h>
#include <string.h>
#include "text_oem.h"
#ifdef _WINDOWS
#include "stream_oem.h"
#include "dmcdotnetstream.h"
#endif


#ifdef _WINDOWS
#pragma managed(push, off)
#endif

#ifdef _WINDOWS
#define DMC_DLL_EXPORT __declspec(dllexport)
#define PROPSTR LPWSTR
#define PATHSTR LPCWSTR
#else
#define DMC_DLL_EXPORT
#define WINAPI
#define LPCSTR const char *
#define LPSTR char *
#define PROPSTR unsigned short *
// Windowsɂ16bit(UTF-16)t@CpXʂI/F邪ALinux8bit(UTF-8)t@CpX̂݁B
#define PATHSTR const char *
#endif

extern "C" {

#ifdef _WINDOWS
HINSTANCE hDLLInst;

BOOL WINAPI DllMain(HINSTANCE hInst, DWORD fdwReason, LPVOID lpvReserved) {
	hDLLInst = hInst;
	return TRUE;
}
#endif

//////////////////////////////////////////////
// DMC_TEXTINFO_V5

DMC_DLL_EXPORT DMC_TEXTINFO_V5 *WINAPI DMCDOTNET_NewTextInfoV5() {
	DMC_TEXTINFO_V5 *p = (DMC_TEXTINFO_V5 *)malloc(sizeof(DMC_TEXTINFO_V5));
	if (p != NULL) {
		memset(p, 0, sizeof(DMC_TEXTINFO_V5));
	}
	return p;
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_DisposeTextInfoV5(DMC_TEXTINFO_V5 *p) {
	if (p != NULL) {
		free(p);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_TextInfoV5_Set_GroupName(DMC_TEXTINFO_V5 *p, LPCSTR value) {
	if (p != NULL && value != NULL && strlen(value) < MAX_GROUP_NAME) {
		strcpy((char *)p->GroupName, value);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_TextInfoV5_Set_DefLangName(DMC_TEXTINFO_V5 *p, LPCSTR value) {
	if (p != NULL && value != NULL && strlen(value) < MAX_LANG_NAME) {
		strcpy((char *)p->DefLangName, value);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_TextInfoV5_Set_bBigEndian(DMC_TEXTINFO_V5 *p, int value) {
	if (p != NULL) {
		p->bBigEndian = value;
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_TextInfoV5_Set_Option(DMC_TEXTINFO_V5 *p, unsigned int value) {
	if (p != NULL) {
		p->Option = value;
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_TextInfoV5_Set_Option1(DMC_TEXTINFO_V5 *p, unsigned int value) {
	if (p != NULL) {
		p->Option1 = value;
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_TextInfoV5_Set_Size(DMC_TEXTINFO_V5 *p, long long value) {
	if (p != NULL) {
		p->Size = (Long)value;
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_TextInfoV5_Set_Csv_c(DMC_TEXTINFO_V5 *p, unsigned short value) {
	if (p != NULL) {
		p->Csv_c = value;
	}
}

//////////////////////////////////////////////
// DMC_FILEINFO

DMC_DLL_EXPORT DMC_FILEINFO *WINAPI DMCDOTNET_NewFileInfo() {
	DMC_FILEINFO *p = (DMC_FILEINFO *)malloc(sizeof(DMC_FILEINFO));
	if (p != NULL) {
		memset(p, 0, sizeof(DMC_FILEINFO));
	}
	return p;
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_DisposeFileInfo(DMC_FILEINFO *p) {
	if (p != NULL) {
		free(p);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_FileInfo_Get_DocFormat(DMC_FILEINFO *p, LPSTR buffer, unsigned int bfsz) {
	if (buffer != NULL && bfsz > 0) {
		if (p != NULL && bfsz > strlen(p->DocFormat)) {
			strcpy(buffer, p->DocFormat);
		}
		else {
			buffer[0] = 0;
		}
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_FileInfo_Get_DocSubFormat(DMC_FILEINFO *p, LPSTR buffer, unsigned int bfsz) {
	if (buffer != NULL && bfsz > 0) {
		if (p != NULL && bfsz > strlen(p->DocFormat)) {
			strcpy(buffer, p->DocSubFormat);
		}
		else {
			buffer[0] = 0;
		}
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_FileInfo_Get_DocCountry(DMC_FILEINFO *p, LPSTR buffer, unsigned int bfsz) {
	if (buffer != NULL && bfsz > 0) {
		if (p != NULL && bfsz > strlen(p->DocFormat)) {
			strcpy(buffer, p->DocCountry);
		}
		else {
			buffer[0] = 0;
		}
	}
}

DMC_DLL_EXPORT int WINAPI DMCDOTNET_FileInfo_Get_ProtectCode(DMC_FILEINFO *p) {
	if (p != NULL) {
		return p->ProtectCode;
	}
	return 0;
}

DMC_DLL_EXPORT int WINAPI DMCDOTNET_FileInfo_Get_FileType(DMC_FILEINFO *p) {
	if (p != NULL) {
		return p->FileType;
	}
	return 0;
}

//////////////////////////////////////////////
// DMC_PROPERTY

DMC_DLL_EXPORT DMC_PROPERTY *WINAPI DMCDOTNET_NewProperty() {
	DMC_PROPERTY *p = (DMC_PROPERTY *)malloc(sizeof(DMC_PROPERTY));
	if (p != NULL) {
		memset(p, 0, sizeof(DMC_PROPERTY));
	}
	return p;
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_DisposeProperty(DMC_PROPERTY *p) {
	if (p != NULL) {
		free(p);
	}
}

void PropCopyToBuffer(char *data, PROPSTR buffer, unsigned int bfsz, unsigned int sz) {
	// vpeB𓾂ƂGroupName = "UTF-16"OB
	if (buffer != NULL && bfsz > 0) {
		unsigned int si, di;
		unsigned short *src = (unsigned short *)data;
		buffer[0] = 0;
		for (si = 0, di = 0; si < sz / 2 && di < bfsz - 1;) {
			if (src[si] == 0xFEFF) {
				si++;
				continue;
			}
			buffer[di] = src[si];
			if (buffer[di] == 0) {
				break;
			}
			buffer[di + 1] = 0;
			si++;
			di++;
		}
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_title(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->title, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_author(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->author, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_keyword(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->keyword, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_subject(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->subject, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_comment(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->comment, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_manager(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->manager, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_company(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->company, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_category(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->category, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_createdate(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->createdate, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_revision(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->revision, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_lastrevisor(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->lastrevisor, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_revisioncount(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->revisioncount, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_lastprintdate(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->lastprintdate, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_edittime(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->edittime, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_creator(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->creator, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_producer(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->producer, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_encryptionflag(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->encryptionflag, buffer, bfsz, 32);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_slides(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->slides, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_paragraphs(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->paragraphs, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_bytes(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->bytes, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_notes(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->notes, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_presentation(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->presentation, buffer, bfsz, MAXCHARBUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_doctype(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->doctype, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_lastsavetime(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->lastsavetime, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_owner(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->owner, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_abstract(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->abstract, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_account(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->account, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_address(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->address, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_attachments(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->attachments, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_authorization(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->authorization, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_bill_to(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->bill_to, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_blind_copy(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->blind_copy, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_carbon_copy(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->carbon_copy, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_checked_by(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->checked_by, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_client(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->client, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_department(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->department, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_descriptive_name(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->descriptive_name, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_descriptive_type(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->descriptive_type, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_destination(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->destination, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_disposition(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->disposition, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_division(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->division, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_document_number(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->document_number, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_editor(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->editor, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_forward_to(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->forward_to, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_group(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->group, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_language(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->language, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_mail_stop(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->mail_stop, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_matter(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->matter, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_office(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->office, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_project(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->project, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_publisher(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->publisher, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_purpose(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->purpose, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_received_from(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->received_from, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_recorded_by(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->recorded_by, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_recorded_date(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->recorded_date, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_reference(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->reference, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_revision_date(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->revision_date, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_revision_notes(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->revision_notes, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_section(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->section, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_security(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->security, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_source(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->source, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_status(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->status, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_telephone_number(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->telephone_number, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_typist(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->typist, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_version_date(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->version_date, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_version_notes(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->version_notes, buffer, bfsz, MAXDATABUF);
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_Property_Get_version_number(DMC_PROPERTY *p, PROPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		PropCopyToBuffer(p->version_number, buffer, bfsz, MAXDATABUF);
	}
}


//////////////////////////////////////////////
// Password

DMC_DLL_EXPORT unsigned char *WINAPI DMCDOTNET_NewPassword(LPCSTR password) {
	if (password != NULL) {
		unsigned int sz = (unsigned int)strlen(password) + 16;
		char *p = (char *)malloc(sz);
		if (p != NULL) {
			memset(p, 0, sz);
			strcpy(p, password);
		}
		return (unsigned char *)p;
	}
	else {
		return NULL;
	}
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_DisposePassword(unsigned char *p) {
	if (p != NULL) {
		free(p);
	}
}

//////////////////////////////////////////////
// LDDMC_OLEERR

DMC_DLL_EXPORT int WINAPI DMCDOTNET_OleErr_Get_LevNum(LDDMC_OLEERR *p) {
	if (p != NULL) {
		return  p->LevNum;
	}
	return 0;
}

DMC_DLL_EXPORT DWord WINAPI DMCDOTNET_OleErr_Get_ErrCode(LDDMC_OLEERR *p) {
	if (p != NULL) {
		return  p->ErrCode;
	}
	return 0;
}

DMC_DLL_EXPORT void WINAPI DMCDOTNET_OleErr_Get_DtctResult(LDDMC_OLEERR *p, LPSTR buffer, unsigned int bfsz) {
	if (p != NULL) {
		strcpy(buffer, (const char *)p->DtctResult);
	}
}

//////////////////////////////////////////////


DMC_DLL_EXPORT int WINAPI DMCDOTNET_GetText_V5(PATHSTR appFile, PATHSTR txtFile, DMC_TEXTINFO_V5 *textInfo, DMC_OLEERR_CALLBACK pFuncOleError) {
#ifdef _WINDOWS
	return DMC_GetText_V5W((Word *)appFile, (Word *)txtFile, textInfo, pFuncOleError);
#else
	return DMC_GetText_V5((Byte *)appFile, (Byte *)txtFile, textInfo, pFuncOleError);
#endif
}

DMC_DLL_EXPORT int DMCDOTNET_GetFileInfo_V5(PATHSTR appFile, DMC_FILEINFO *fileInfo, DMC_TEXTINFO_V5 *textInfo) {
#ifdef _WINDOWS
	return DMC_GetFileInfo_V5W((Word *)appFile, fileInfo, textInfo);
#else
	return DMC_GetFileInfo_V5((Byte *)appFile, fileInfo, textInfo);
#endif
}

DMC_DLL_EXPORT int DMCDOTNET_GetProperty_V5(PATHSTR appFile, DMC_TEXTINFO_V5 *textInfo, DMC_PROPERTY *prop) {
	DMC_TEXTINFO_V5 tmpTextInfo;
	memcpy(&tmpTextInfo, textInfo, sizeof(DMC_TEXTINFO_V5));
	strcpy((char *)tmpTextInfo.GroupName, UTF16);
	tmpTextInfo.bBigEndian = 0;
#ifdef _WINDOWS
	return DMC_GetProperty_V5W((Word *)appFile, &tmpTextInfo, prop);
#else
	return DMC_GetProperty_V5((Byte *)appFile, &tmpTextInfo, prop);
#endif
}

DMC_DLL_EXPORT int WINAPI DMCDOTNET_GetPageText_V5(PATHSTR appFile, PATHSTR txtFile, DMC_TEXTINFO_V5 *textInfo, int *pages, DMC_OLEERR_CALLBACK pFuncOleError) {
#ifdef _WINDOWS
	return DMC_GetPageText_V5W((Word *)appFile, (Word *)txtFile, textInfo, pages, pFuncOleError);
#else
	return DMC_GetPageText_V5((Byte *)appFile, (Byte *)txtFile, textInfo, pages, pFuncOleError);
#endif
}

DMC_DLL_EXPORT int WINAPI DMCDOTNET_GetPwdText_V5(PATHSTR appFile, PATHSTR txtFile, DMC_TEXTINFO_V5 *textInfo, Byte *password, DMC_OLEERR_CALLBACK pFuncOleError) {
#ifdef _WINDOWS
	return DMC_GetPwdText_V5W((Word *)appFile, (Word *)txtFile, textInfo, password, pFuncOleError);
#else
	return DMC_GetPwdText_V5((Byte *)appFile, (Byte *)txtFile, textInfo, password, pFuncOleError);
#endif
}

DMC_DLL_EXPORT int WINAPI DMCDOTNET_GetPwdPageText_V5(PATHSTR appFile, PATHSTR txtFile, DMC_TEXTINFO_V5 *textInfo, int *pages, Byte *password, DMC_OLEERR_CALLBACK pFuncOleError) {
#ifdef _WINDOWS
	return DMC_GetPwdPageText_V5W((Word *)appFile, (Word *)txtFile, textInfo, pages, password, pFuncOleError);
#else
	return DMC_GetPwdPageText_V5((Byte *)appFile, (Byte *)txtFile, textInfo, pages, password, pFuncOleError);
#endif
}

DMC_DLL_EXPORT int DMCDOTNET_GetPwdProperty_V5(PATHSTR appFile, DMC_TEXTINFO_V5 *textInfo, DMC_PROPERTY *prop, Byte *password) {
	DMC_TEXTINFO_V5 tmpTextInfo;
	memcpy(&tmpTextInfo, textInfo, sizeof(DMC_TEXTINFO_V5));
	strcpy((char *)tmpTextInfo.GroupName, UTF16);
	tmpTextInfo.bBigEndian = 0;
#ifdef _WINDOWS
	return DMC_GetPwdProperty_V5W((Word *)appFile, &tmpTextInfo, prop, password);
#else
	return DMC_GetPwdProperty_V5((Byte *)appFile, &tmpTextInfo, prop, password);
#endif
}

#ifdef _WINDOWS

// TextPorterDotNet I/F.NETStreamC++ STLstd::ostreamт邽߂Ƀ}l[WhC++𗘗pĂB
// }l[WhC++RpCLinuxɂ͂ȂB
// 2021.07.20 Takeshi Yoneki

DMC_DLL_EXPORT int DMCDOTNET_GetTextStream_V5(PATHSTR appfile, void *outStream, DMC_TEXTINFO_V5* textInfo, DMC_OLEERR_CALLBACK pFuncOleError) {
	DMCDOTNETStreamBridge *stream = new DMCDOTNETStreamBridge(outStream);
	int result = DMC_GetTextStream_V5W((Word *)appfile, stream, textInfo, pFuncOleError);
	delete stream;
	return result;
}

DMC_DLL_EXPORT int DMCDOTNET_GetPageTextStream_V5(PATHSTR appfile, void * outStream, DMC_TEXTINFO_V5* textInfo, int *pages, DMC_OLEERR_CALLBACK pFuncOleError) {
	DMCDOTNETStreamBridge *stream = new DMCDOTNETStreamBridge(outStream);
	int result = DMC_GetPageTextStream_V5W((Word *)appfile, stream, textInfo, pages, pFuncOleError);
	delete stream;
	return result;
}

#endif

}

#ifdef _WINDOWS
#pragma managed(pop)
#endif
