#!/bin/sh

if test "$1" = "d"; then
	shift;
	BUILDMODE=Debug
else
	BUILDMODE=Release
fi

if ! test -d $BUILDMODE; then
	mkdir $BUILDMODE
fi

if ! test -d dmcdotnetif/$BUILDMODE; then
	mkdir dmcdotnetif/$BUILDMODE
fi

VERSION_MAJOR=6
VERSION_MINOR=0
VERSION_MICRO=0

# dmcdotnet/dmcdotnet.csproj
# sample/sample.csproj
# の記述に合わせる。
#DOTNETBINDIR=net6.0
DOTNETBINDIR=net8.0

# -L dmcdotnetif/Lib
# -ldmc_txif
# dmcdotnetif/Lib/ にlibdmc_txif.so.6.0 を libdmc_txif.so としてコピーしておく。

echo g++ $BUILDMODE
if [ $BUILDMODE = Debug ]; then
	g++ -v -c -D_REENTRANT -fPIC -g -D_DEBUG -o dmcdotnetif/$BUILDMODE/dmcdotnetif.o dmcdotnetif/dmcdotnetif.cpp
else
	g++ -v -c -D_REENTRANT -fPIC -O3 -o dmcdotnetif/$BUILDMODE/dmcdotnetif.o dmcdotnetif/dmcdotnetif.cpp
fi
g++ -shared -Wl,-soname,libdmcdotnetif.so.$VERSION_MAJOR -L dmcdotnetif/Lib dmcdotnetif/$BUILDMODE/dmcdotnetif.o -l dmc_txif -o $BUILDMODE/libdmcdotnetif.so.$VERSION_MAJOR.$VERSION_MINOR

cd dmcdotnet
dotnet build -c $BUILDMODE
cd ..
cd sample
dotnet build -c $BUILDMODE
cd ..
cp dmcdotnet/bin/$BUILDMODE/$DOTNETBINDIR/dmcdotnet.dll $BUILDMODE
cp sample/bin/$BUILDMODE/$DOTNETBINDIR/sample.dll $BUILDMODE
cp sample/bin/$BUILDMODE/$DOTNETBINDIR/sample.runtimeconfig.json $BUILDMODE
cd $BUILDMODE
rm libdmcdotnetif.so
mv libdmcdotnetif.so.$VERSION_MAJOR.$VERSION_MINOR libdmcdotnetif.so
#rm libdmcdotnetif.so.$VERSION_MAJOR
#ln -s libdmcdotnetif.so.$VERSION_MAJOR.$VERSION_MINOR libdmcdotnetif.so.$VERSION_MAJOR
#rm libdmcdotnetif.so
#ln -s libdmcdotnetif.so.$VERSION_MAJOR libdmcdotnetif.so
cd ..
