/*
 * Copyright (C) 1999 AntennaHouse Inc.  All Rights Reserved
 */

/*----------------------------------
   TITLE:TEXT_OEM.H
   PRODUCT:DMC Product
   Comment:DMC Interface
   ------------------------------------*/
/*
 * Author:Tian Hu
 *
 * 1999/09/01 First Release
 */
 

#ifndef _TEXT_OEM_H_
#define _TEXT_OEM_H_

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */

/* change for the case, only _WIN32 defined without _WINDOWS */
#if defined(_WINDOWS) || defined(_WIN32) || defined(WIN32) || defined(WIN64) || defined(_WIN64)
	#if defined(_WIN64) || defined(WIN64)
		#define DMC_WINDOWS_X86_64
	#else
		#if defined(_WIN32) || defined(WIN32)
			#define DMC_WINDOWS_X86_32
		#endif
	#endif
#endif

//////////////////////////////////////////////////
// vbgtH[̒`
//////////////////////////////////////////////////

#ifdef DMC_WINDOWS_X86_32
	#define DMC_WIN
	#define DMC_WIN32
	#define DMC_OS_BITS_32
	#define DMC_CPU_X86
	#define DMC_ENDIAN_IS_BIG			0
	#define DMC_ENDIAN_IS_LITTLE		1
#endif
#ifdef DMC_WINDOWS_X86_64
	#define DMC_WIN
	#define DMC_WIN64
	#define DMC_OS_BITS_64
	#define DMC_CPU_X86
	#define DMC_WIN64FS
	#define DMC_ENDIAN_IS_BIG			0
	#define DMC_ENDIAN_IS_LITTLE		1
#endif
#ifdef DMC_LINUX_X86_32
	#define DMC_LINUX
	#define DMC_UNIX
	#define DMC_OS_BITS_32
	#define DMC_CPU_X86
	#define DMC_ENDIAN_IS_BIG			0
	#define DMC_ENDIAN_IS_LITTLE		1
#endif
#ifdef DMC_LINUX_X86_64
	#define DMC_LINUX
	#define DMC_UNIX
	#define DMC_OS_BITS_64
	#define DMC_CPU_X86
	#define DMC_ENDIAN_IS_BIG			0
	#define DMC_ENDIAN_IS_LITTLE		1
#endif
#ifdef DMC_SOLARIS_SPARC_32
	#define DMC_SOLARIS
	#define DMC_UNIX
	#define DMC_OS_BITS_32
	#define DMC_CPU_SPARC
	#define DMC_ENDIAN_IS_BIG			1
	#define DMC_ENDIAN_IS_LITTLE		0
#endif
#ifdef DMC_SOLARIS_SPARC_64
	#define DMC_SOLARIS
	#define DMC_UNIX
	#define DMC_OS_BITS_64
	#define DMC_CPU_SPARC
	#define DMC_ENDIAN_IS_BIG			1
	#define DMC_ENDIAN_IS_LITTLE		0
#endif
#ifdef DMC_SOLARIS_X86_64
	#define DMC_SOLARIS
	#define DMC_UNIX
	#define DMC_OS_BITS_64
	#define DMC_CPU_X86
	#define DMC_ENDIAN_IS_BIG 			0
	#define DMC_ENDIAN_IS_LITTLE 		1
#endif
#ifdef DMC_AIX_POWER_32
	#define DMC_AIX
	#define DMC_UNIX
	#define DMC_OS_BITS_32
	#define DMC_CPU_POWER
	#define DMC_ENDIAN_IS_BIG			1
	#define DMC_ENDIAN_IS_LITTLE		0
#endif
#ifdef DMC_AIX_POWER_64
	#define DMC_AIX
	#define DMC_UNIX
	#define DMC_OS_BITS_64
	#define DMC_CPU_POWER
	#define DMC_ENDIAN_IS_BIG			1
	#define DMC_ENDIAN_IS_LITTLE		0
#endif
#ifdef DMC_HPUX_PARISC_32
	// DMC_HPUX11V1
	#define DMC_HPUX
	#define DMC_UNIX
	#define DMC_OS_BITS_32
	#define DMC_CPU_PARISC
	#define DMC_ENDIAN_IS_BIG			1
	#define DMC_ENDIAN_IS_LITTLE		0
#endif
#ifdef DMC_HPUX_IA_64
	#define DMC_HPUX
	#define DMC_UNIX
	#define DMC_OS_BITS_64
	#define DMC_CPU_IA
	#define DMC_ENDIAN_IS_BIG			1
	#define DMC_ENDIAN_IS_LITTLE		0
#endif
#ifdef DMC_MACOSX_POWER_32
	#define DMC_MACOSX
	#define DMC_UNIX
	#define DMC_OS_BITS_32
	#define DMC_CPU_POWER
	#define DMC_ENDIAN_IS_BIG			1
	#define DMC_ENDIAN_IS_LITTLE		0
#endif
#ifdef DMC_MACOSX_X86_32
	#define DMC_MACOSX
	#define DMC_UNIX
	#define DMC_OS_BITS_32
	#define DMC_CPU_X86
	#define DMC_ENDIAN_IS_BIG			0
	#define DMC_ENDIAN_IS_LITTLE		1
#endif

#ifdef DMC_WIN
	#define DMC_IS_WIN					1
#else
	#define DMC_IS_WIN					0
#endif

#ifdef DMC_UNIX
	#define DMC_IS_UNIX					1
#else
	#define DMC_IS_UNIX					0
#endif

//#ifndef DMCV3
//	#define DMCV3
//#endif

/***
	Common Type
 ***/

//
typedef int INT;
//

typedef int Bool;
typedef int DMC_Bool;

#ifndef DMC_TRUE
	#define DMC_TRUE   (1)
	#define DMC_FALSE  (0)
#endif

	#define BOOL DMC_Bool

#ifndef DMC_AIX
	typedef char int8;
	typedef short int16;
	typedef int int32;
#endif

	typedef unsigned char uint8;
	typedef unsigned short uint16;
	typedef unsigned int uint32;

// K64bitȐ
#ifdef DMC_WIN
	#if _MSC_VER < 1300	// VC++2003ȑO(VC++6)
		// VC++6ɂ64bitȂ
		// `͂邪32bit
		typedef long int64;
		typedef unsigned long uint64;
	#else
		typedef long long int64;
		typedef unsigned long long uint64;
	#endif
#else
	#ifndef DMC_AIX
		typedef long long int64;
	#endif
	typedef unsigned long long uint64;
#endif

	typedef unsigned char Byte;
	typedef unsigned short Word;
	typedef unsigned int DWord;

// 32bitł32bitA64bitł64bit̐
// Windows64bitłlong32bit
// Unix/Linux64bit̏ꍇlong64bit
#ifdef DMC_WIN64FS
//#ifdef DMC_WIN64
	typedef long long Long;
	typedef unsigned long long LWord;
#else
	typedef long Long;
	typedef unsigned long LWord;
#endif

// VC++2005ł͏]̕WCȗZLeBɖ肪ƂČx𔭂̂ł}
#ifdef DMC_WIN
	#if _MSC_VER >= 1400	// VC++2005
		#pragma warning(disable:4996)
	#endif
#endif

/***
	Interface structure
 ***/

#define MAX_GROUP_NAME 256
#define MAX_LANG_NAME 256

typedef BOOL (UsrFunc)(void);

typedef struct {
	Byte	GroupName[MAX_GROUP_NAME];
	Byte	DefLangName[MAX_LANG_NAME];
	BOOL	bBigEndian;
	DWord	Option;
	DWord	Option1;
	Long	Size;
		// DWord -> Long 2006.05.24 Takeshi Yoneki
	Word	Csv_c;
	//UsrFunc *pFunc;
} DMC_TEXTINFO_V4, *LPDMC_TEXTINFO_V4;

typedef struct {
	Byte	GroupName[MAX_GROUP_NAME];
	Byte	DefLangName[MAX_LANG_NAME];
	BOOL	bBigEndian;
	DWord	Option;
	DWord	Option1;
	Long	Size;
	Word	Csv_c;
} DMC_TEXTINFO_V5, *LPDMC_TEXTINFO_V5;

#define DMC_GETTEXT_OPT_KEISEN	0x00000001
#define DMC_GETTEXT_OPT_TAG		0x00000002
#define DMC_GETTEXT_OPT_RUBI	0x00000004
#define DMC_GETTEXT_OPT_CRLF	0x00000008
#define DMC_GETTEXT_OPT_CR		0x00000010
#define DMC_GETTEXT_OPT_LF		0x00000020
#define DMC_GETTEXT_OPT_U2028	0x00000040
#define DMC_GETTEXT_OPT_U2029	0x00000080
#define DMC_GETTEXT_OPT_SHEET	0x00000100
#define DMC_GETTEXT_OPT_PWD		0x00000400
#define DMC_GETTEXT_OPT_OLE		0x00001000
#define DMC_GETTEXT_OPT_OLE1	0x00002000
#define DMC_GETTEXT_OPT_OLE2	0x00004000
#define DMC_GETTEXT_OPT_OLE3	0x00008000
#define DMC_GETTEXT_OPT_OUT		0x00010000
#define DMC_GETTEXT_OPT_LOOP	0x00020000
#define DMC_GETTEXT_OPT_SHFTAG	0x00040000
#define DMC_GETTEXT_OPT_SHFHEAD	0x00080000
#define DMC_GETTEXT_OPT_SHEET1	0x00100000
#define DMC_GETTEXT_OPT_CELL	0x00200000
#define DMC_GETTEXT_OPT_SIZE	0x00400000
#define DMC_GETTEXT_OPT_PDFSYM	0x00800000
#define DMC_GETTEXT_OPT_CSV1	0x01000000
#define DMC_GETTEXT_OPT_CSV2	0x02000000
#define DMC_GETTEXT_OPT_ENDCODE	0x04000000
#define DMC_GETTEXT_OPT_NULL	0x08000000
#define DMC_GETTEXT_OPT_OWNERPWD1	0x10000000
#define DMC_GETTEXT_OPT_OWNERPWD2	0x20000000
#define DMC_GETTEXT_OPT_OWNERPWD3	0x40000000
#define DMC_GETTEXT_OPT_OWNERPWD4	0x80000000
/* Option1 */
#define DMC_GETTEXT_OPT1_TEMP    0x00000001
#define DMC_GETTEXT_OPT1_INSERTF     0x00000002
#define DMC_GETTEXT_OPT1_INSERTF1	0x00000004
#define DMC_GETTEXT_OPT1_INSERTF2	0x00000008
#define DMC_GETTEXT_OPT1_INSERTF3	0x00000010
#define DMC_GETTEXT_OPT1_OWNERPWD5	0x00000020
#define DMC_GETTEXT_OPT1_COMPRESS  0x00000100
#define DMC_GETTEXT_OPT1_COMPRESS1 0x00000200
#define DMC_GETTEXT_OPT1_COMPRESS2 0x00000400
#define DMC_GETTEXT_OPT1_COMPRESS3 0x00000800
#define DMC_GETTEXT_OPT1_COMPRESS4 0x00001000
#define DMC_GETTEXT_OPT1_TRACK     0x00002000
#define DMC_GETTEXT_OPT1_COMPRESS5    0x00004000//2006/01/24 add for not output "Filename"and"Content:"
#define DMC_GETTEXT_OPT1_INSERTF4     0x00008000//2006/01/24 add for not output "Attach?"......
#define DMC_GETTEXT_OPT1_TXCONV       0x00010000//2006/01/24 add for txt code convert
#define DMC_GETTEXT_OPT1_TXCONV2      0x00020000//2006/01/24 add for not output txt
#define DMC_GETTEXT_OPT1_OUTPUT_RAW_NL	0x00040000 //2012/05/23 add to output raw newline
#define DMC_GETTEXT_OPT1_QUOTE_QQ	0x00080000 //2012/05/28 add to express '"' by '""' in quoted csv


#define EUCJP			"EUC-JP"
#define EUCJP_FIX		"EUC-JP-FIX"
#define ISO10646_UCS2		"ISO-10646-UCS-2"
#define ISO10646_UCS4		"ISO-10646-UCS-4"
#define ISO2022_JP		"ISO-2022-JP"
#define ISO8859_1		"ISO-8859-1"
#define Shift_JIS		"Shift_JIS"
#define UTF16			"UTF-16"
#define UTF8			"UTF-8"
#define WINDOWS31J		"WINDOWS31J"
#define ChineseGBK		"ChineseGBK"
#define ChineseBig5		"ChineseBIG5"
#define ChineseGB18030		"GB18030"
#define KoreanKSC		"KoreanKSC"
#define Shift_JIS_2004 		"Shift_JIS-2004"//2006/08/02 add
#define ISO_2022_JP_2004 	"ISO-2022-JP-2004"//2006/08/02 add
#define EUC_JIS_2004 		"EUC-JIS-2004"//2006/08/02 add
#define EUC_JP 			"EUC-JP"//2006/08/02 add
#define ISO_2022_JP 		"ISO-2022-JP"//2006/08/02 add


/* 2000.07.04 By Lin Hong */
//	DocFormat
#define	DTCT_HTML	"HTML"
#define	DTCT_PDF1_0	"PDF1.0"
#define	DTCT_PDF1_1 "PDF1.1"
#define	DTCT_PDF1_2	"PDF1.2"
#define	DTCT_PDF1_3	"PDF1.3"
#define DTCT_PDF1_4	"PDF1.4"
#define	DTCT_PDF1_5	"PDF1.5"
#define	DTCT_PDF1_6	"PDF1.6"
#define	DTCT_PDF1_7	"PDF1.7"
#define	DTCT_PDF_UNKNOWN 	"PDF unknown version"
#define DTCT_PS		"PostScript"
#define	DTCT_RTF	"Microsoft RTF"
#define	DTCT_WD6	"Word Ver.6"
#define	DTCT_WD7    "Word Ver.7(95)"
#define	DTCT_WD97	"Word 97"
#define	DTCT_WD98	"Word 98"
#define	DTCT_WD2K	"Word 2000"
#define	DTCT_WDXP	"Word XP"
#define	DTCT_WD2003	"Word 2003"
#define	DTCT_WD2001	"Mac-Word 2001"
#define	DTCT_WDXML	"Word XML"
#define	DTCT_WD2007	"Word 2007"
#define	DTCT_WD2007MC	"Word 2007 with Macro"
#define	DTCT_WD2007TP	"Word 2007 Template"
#define	DTCT_WD2007MCTP	"Word 2007 Template with Macro"
#define	DTCT_WD2007ENC	"Word 2007 Encrypted"
#define DTCT_WD2010	"Word 2010"
#define DTCT_WD2010MC	"Word 2010 with Macro"
#define DTCT_WD2010TP	"Word 2010 Template"
#define DTCT_WD2010MCTP	"Word 2010 Template with Macro"
#define	DTCT_WD2010ENC	"Word 2010 Encrypted"
#define DTCT_WD2013	"Word 2013"
#define DTCT_WD2013MC	"Word 2013 with Macro"
#define DTCT_WD2013TP	"Word 2013 Template"
#define DTCT_WD2013MCTP	"Word 2013 Template with Macro"
#define	DTCT_WD2013ENC	"Word 2013 Encrypted"
#define DTCT_WD2016	"Word 2016"
#define DTCT_WD2016MC	"Word 2016 with Macro"
#define DTCT_WD2016TP	"Word 2016 Template"
#define DTCT_WD2016MCTP	"Word 2016 Template with Macro"
#define	DTCT_WD2016ENC	"Word 2016 Encrypted"
// not used.
// 2011.01.27 Taleshi Yoneki
//#define DTCT_WD2010ENC	"inavlid 001"
//
#define	DTCT_EXL4	"Excel Ver.4"
#define	DTCT_EXL5	"Excel Ver.5/7(95)"
#define	DTCT_EXL7	"Excel 97/2000/XP"
#define	DTCT_EXL8   "Excel 98"
#define	DTCT_EXL9   "Mac-Excel 2001"
#define	DTCT_EXL2003   "Excel 2003"
#define	DTCT_EXLXML	"Excel XML"
#define	DTCT_EXL2007	"Excel 2007"
#define	DTCT_EXL2007MC	"Excel 2007 with Macro"
#define	DTCT_EXL2007TP	"Excel 2007 Template"
#define	DTCT_EXL2007MCTP	"Excel 2007 Template with Macro"
#define	DTCT_EXL2007MCBN	"Excel 2007 Binary with Macro"
#define	DTCT_EXL2007ENC	"Excel 2007 Encrypted"
#define DTCT_EXL2010	"Excel 2010"
#define DTCT_EXL2010MC	"Excel 2010 with Macro"
#define DTCT_EXL2010TP	"Excel 2010 Template"
#define DTCT_EXL2010MCTP	"Excel 2010 Template with Macro"
#define DTCT_EXL2010MCBN	"Excel 2010 Binary with Macro"
#define	DTCT_EXL2010ENC	"Excel 2010 Encrypted"
#define DTCT_EXL2013	"Excel 2013"
#define DTCT_EXL2013MC	"Excel 2013 with Macro"
#define DTCT_EXL2013TP	"Excel 2013 Template"
#define DTCT_EXL2013MCTP	"Excel 2013 Template with Macro"
#define DTCT_EXL2013MCBN	"Excel 2013 Binary with Macro"
#define	DTCT_EXL2013ENC	"Excel 2013 Encrypted"
#define DTCT_EXL2016	"Excel 2016"
#define DTCT_EXL2016MC	"Excel 2016 with Macro"
#define DTCT_EXL2016TP	"Excel 2016 Template"
#define DTCT_EXL2016MCTP	"Excel 2016 Template with Macro"
#define DTCT_EXL2016MCBN	"Excel 2016 Binary with Macro"
#define	DTCT_EXL2016ENC	"Excel 2016 Encrypted"
#define	DTCT_PPT5	"PowerPoint 95"
#define	DTCT_PPT7	"PowerPoint 97/2000/XP"
#define	DTCT_PPT9	"Mac-PowerPoint 2001"
#define	DTCT_PPT2003	"PowerPoint 2003"
#define	DTCT_PPT2007	"PowerPoint 2007"
#define	DTCT_PPT2007MC	"PowerPoint 2007 with Macro"
#define	DTCT_PPT2007SS	"PowerPoint 2007 Slide Show"
#define	DTCT_PPT2007MCSS	"PowerPoint 2007 Slide Show with Macro"
#define	DTCT_PPT2007TP	"PowerPoint 2007 Template"
#define	DTCT_PPT2007MCTP	"PowerPoint 2007 Template with Macro"
#define	DTCT_PPT2007ENC	"PowerPoint 2007 Encrypted"
#define DTCT_PPT2010	"PowerPoint 2010"
#define DTCT_PPT2010MC	"PowerPoint 2010 with Macro"
#define DTCT_PPT2010SS	"PowerPoint 2010 Slide Show"
#define DTCT_PPT2010MCSS	"PowerPoint 2010 Slide Show with Macro"
#define DTCT_PPT2010TP	"PowerPoint 2010 Template"
#define DTCT_PPT2010MCTP	"PowerPoint 2010 Template with Macro"
#define	DTCT_PPT2010ENC	"PowerPoint 2010 Encrypted"
#define DTCT_PPT2013	"PowerPoint 2013"
#define DTCT_PPT2013MC	"PowerPoint 2013 with Macro"
#define DTCT_PPT2013SS	"PowerPoint 2013 Slide Show"
#define DTCT_PPT2013MCSS	"PowerPoint 2013 Slide Show with Macro"
#define DTCT_PPT2013TP	"PowerPoint 2013 Template"
#define DTCT_PPT2013MCTP	"PowerPoint 2013 Template with Macro"
#define	DTCT_PPT2013ENC	"PowerPoint 2013 Encrypted"
#define DTCT_PPT2016	"PowerPoint 2016"
#define DTCT_PPT2016MC	"PowerPoint 2016 with Macro"
#define DTCT_PPT2016SS	"PowerPoint 2016 Slide Show"
#define DTCT_PPT2016MCSS	"PowerPoint 2016 Slide Show with Macro"
#define DTCT_PPT2016TP	"PowerPoint 2016 Template"
#define DTCT_PPT2016MCTP	"PowerPoint 2016 Template with Macro"
#define	DTCT_PPT2016ENC	"PowerPoint 2016 Encrypted"
#define	DTCT_LTS5	"Lotus 1-2-3 V5"
#define	DTCT_LYS7	"Lotus 1-2-3 97/98"
#define	DTCT_LYSMI  "Lotus 1-2-3 Millennium Edition"
#define	DTCT_LYS2K  "Lotus 1-2-3 2000"
#define	DTCT_TARO4	"Ichitaro V4"
#define	DTCT_TARO5	"Ichitaro V5"
#define	DTCT_TARO6	"Ichitaro V6"
#define	DTCT_TARO7	"Ichitaro V7"
#define DTCT_TARO8	"Ichitaro Document"	// 2009.12.25 
#define	DTCT_OASYS1	"OASYS Separated"
#define	DTCT_OASYS2	"OASYS Combined"
#define	DTCT_OASYS3	"OASYS Compound"
#define	DTCT_OASYSL	"OASYS Online"
#define	DTCT_CW4	"Claris Works 4.0"
#define	DTCT_CW4WP	"Claris Works 4.0 WP"
#define	DTCT_CW4SS	"Claris Works 4.0 SS"
#define	DTCT_CW4DB	"Claris Works 4.0 DB"
#define	DTCT_WPD6	"WordPerfect 6.0"
#define	DTCT_WPD789	"WordPerfect 7/8/9"
#define	DTCT_SHW789	"Corel Presentations Slide Show 7/8/9"
#define	DTCT_PM6	"Page Maker 6.0"
#define	DTCT_PM65	"Page Maker 6.5/7.0"
#define	DTCT_MACPM6	"Mac Page Maker 6.0"
#define	DTCT_MACPM65	"Mac Page Maker 6.5/7.0"
#define	DTCT_MSWORKSWP	"MS Works 2000 WPS"
#define	DTCT_MSWORKSDB	"MS Works 2000 WDB"
#define	DTCT_MSWORKSKS	"MS Works 2000 WKS"
#define	DTCT_ACADR14DXF	"AutoCAD R14/LT97 DXF"
#define	DTCT_ACADR14DXFBIN	"AutoCAD R14/LT97 DXF BIN"
#define	DTCT_ACADR14DWG	"AutoCAD R14/LT97 DWG"
#define	DTCT_ACAD2KDXF	"AutoCAD 2000 DXF"
#define	DTCT_ACAD2KDXFBIN	"AutoCAD 2000 DXF BIN"
#define	DTCT_ACAD2KDWG	"AutoCAD 2000 DWG"
#define	DTCT_ACAD2007DWG	"AutoCAD 2007 DWG"//2009/12/10 add
#define	DTCT_ACAD2007DXF	"AutoCAD 2007 DXF"//2009/12/22 add
#define	DTCT_QXD	"QuarkXPress"
#define	DTCT_MACWRT	"Mac Write II"
#define	DTCT_WP 	"Quattro Pro for Dos"
#define	DTCT_WB1	"Quattro Pro for Windows"
#define	DTCT_WB2	"Quattro Pro v6"
#define	DTCT_WB3	"Quattro Pro v7v8"
#define	DTCT_QPW	"Quattro Pro v9"
#define	DTCT_ACADR13DWG	"AutoCAD R13/LT95 DWG"
#define	DTCT_ACADR13DXF	"AutoCAD R13/LT95 DXF"
#define	DTCT_ACADR13DXFBIN	"AutoCAD R13/LT95 DXF BIN"
#define	DTCT_AWWP	"Apple Works WP"
#define	DTCT_AWSS	"Apple Works SS"
#define	DTCT_AWDB	"Apple Works DB"
#define	DTCT_AWDR	"Apple Works DR"
#define	DTCT_AWPT	"Apple Works PT"
#define	DTCT_AWPR	"Apple Works PR"
#define	DTCT_ACADGX3DWG	"AutoCAD GX-III DWG"
#define	DTCT_ACADGX3DXF	"AutoCAD GX-III DXF"
#define	DTCT_ACADGX3DXFBIN	"AutoCAD GX-III DXF BIN"
#define	DTCT_ACADR12DWG	"AutoCAD GX-5/R12 DWG"
#define	DTCT_ACADR12DXF	"AutoCAD GX-5/R12 DXF"
#define	DTCT_ACAD2010DWG	"AutoCAD 2010 DWG"//2010/8/3 Ray
#define	DTCT_ACAD2010DXF	"AutoCAD 2010 DXF"//2010/8/3 Ray
#define	DTCT_ACADR12DXFBIN	"AutoCAD GX-5/R12 DXF BIN"
#define	DTCT_XML	"XML"
#define	DTCT_XSL	"XSL"
#define	DTCT_IGES	"IGES"
#define	DTCT_HELP	"HELP"
#define	DTCT_TEXT	"TEXT" //050927
#define	DTCT_EML	"EML"
#define	DTCT_MSG	"MSG"//021112
#define	DTCT_MSG2007	"MSG 2007"//2011/11/12
#define	DTCT_MSG2010	"MSG 2010"//2011/11/12
#define	DTCT_DCXDW6 "DocuWorks v3"
#define	DTCT_DCXDW7 "DocuWorks v4/v5/v6"
#define	DTCT_DCXDW8 "DocuWorks v4/v5/v6"
#define DTCT_DCXDW70 "DocuWorks v7"
#define DTCT_VISIO3 "Visio 3.0"	// 051017
#define DTCT_VISIO4 "Visio 4.0" //050927
#define DTCT_VISIO5 "Visio 5.0" //050927
#define DTCT_VISIO6 "Visio 2000/2002" //050927
#define DTCT_VISIO11 "Visio 2003/2007/2010" //050927
#define DTCT_VISIO2013		"Visio 2013"
#define DTCT_VISIO2013MC	"Visio 2013 with Macro"
#define DTCT_VISIO2013ST	"Visio 2013 Stencil"
#define DTCT_VISIO2013MCST	"Visio 2013 Stencil with Macro"
#define DTCT_VISIO2013TP	"Visio 2013 Template"
#define DTCT_VISIO2013MCTP	"Visio 2013 Template with Macro"
#define	DTCT_KSWPS97 "Kingsoft WPS 97"
#define	DTCT_KSWPS0 "Kingsoft WPS 2000"
	#define	DTCT_KSWPS1 "Kingsoft WPS 2001"
#define	DTCT_KSWPS2 "Kingsoft WPS 2002"
#define	DTCT_KSWPS3 "Kingsoft WPS 2003"
#define DTCT_RAR    "RAR"
#define DTCT_ZIP    "ZIP"
#define DTCT_LZH    "LZH"
#define DTCT_GZIP    "GZIP"
#define DTCT_TAR    "TAR"
#define	DTCT_OPENOFFICE_CALC	"Open Office Calc 1.0"
#define	DTCT_OPENOFFICE_DRAW	"Open Office Draw 1.0"
#define	DTCT_OPENOFFICE_GLOBAL	"Open Office Global 1.0"
#define	DTCT_OPENOFFICE_IMPRESS "Open Office Impress 1.0"
#define	DTCT_OPENOFFICE_MATH	"Open Office Math 1.0"
#define	DTCT_OPENOFFICE_WRITER	"Open Office Writer 1.0"

#define	DTCT_OPENOFFICE_V3_CALC		"Open Office 3.1 Calc"
#define	DTCT_OPENOFFICE_V3_DRAW		"Open Office 3.1 Draw"
#define	DTCT_OPENOFFICE_V3_PRESEN	"Open Office 3.1 Presentation"
#define	DTCT_OPENOFFICE_V3_WRITER	"Open Office 3.1 Writer"

// not used.
#define DTCT_JPEG	"JPEG"
#define DTCT_JPEG2K	"JPEG2K"
//

// MS Office oCiAMS Office OOX̃pX[hɂÍΉŒǉB
// 2013/03/08 by show
#define	DTCT_PROTECTED_MSOFFICE		"Protected Microsoft Office Document"

#define	MultiEncodes	"Multi Charsets" //050927

// DocSubFormat
#define 	OAS_V3	"V3"
#define 	OAS_V4	"V4"
#define 	OAS_V5	"V5"
#define 	OAS_V6	"V6"
#define 	OAS_V7  "V7"
#define 	OAS_V8  "V8"
#define 	OAS_V9  "2002"//020528
#define 	OAS_V10 "V10"		// 2008.04.09 Takeshi Yoneki

//PmSubFormat
#define 	PM_V6_MAC	"MAC_V6"
#define 	PM_V65_MAC	"MAC_V65/70"
#define 	PM_V6_WIN	"WIN_V6"
#define 	PM_V65_WIN	"WIN_V65/70"

// DocCountry
#define	JAPANESE		"Japanese"
#define	ENGLISH			"English"
#define	SIMP_CHINESE	"Simplified Chinese"
#define	TRAD_CHINESE	"Traditional Chinese"
#define	KOREAN			"Korean"

#define MAXPROLEN	256
#define MAXCHARBUF	4*MAXPROLEN+4
#define MAXDATABUF	256
typedef struct
{
	//for most of them
	char title[MAXCHARBUF];
	char author[MAXCHARBUF];
	char keyword[MAXCHARBUF];
	char subject[MAXCHARBUF];
	char comment[MAXCHARBUF];
	char manager[MAXCHARBUF];
	char company[MAXCHARBUF];
	char category[MAXCHARBUF];
	char createdate[MAXDATABUF];
	//lotus123
	char revision[MAXCHARBUF];
	char lastrevisor[MAXCHARBUF];
	char revisioncount[MAXDATABUF];
	char lastprintdate[MAXDATABUF];
	char edittime[MAXDATABUF];
	//pdf
	char creator[MAXCHARBUF];
	char producer[MAXCHARBUF];
	char encryptionflag[32];
	//ppt
	char slides[MAXDATABUF];
	char paragraphs[MAXDATABUF];
	char bytes[MAXDATABUF];
	char notes[MAXDATABUF];
	char presentation[MAXCHARBUF];
	//oasys
	char doctype[MAXDATABUF];
	char lastsavetime[MAXDATABUF];
	char owner[MAXDATABUF];
	//wpd use, Add by li yiyun 2000/8/30
	char abstract[MAXDATABUF];
	char account[MAXDATABUF];
	char address[MAXDATABUF];
	char attachments[MAXDATABUF];
	char authorization[MAXDATABUF];
	char bill_to[MAXDATABUF];              
	char blind_copy[MAXDATABUF];
	char carbon_copy[MAXDATABUF];
	char checked_by[MAXDATABUF];
	char client[MAXDATABUF];
	char department[MAXDATABUF];
	char descriptive_name[MAXDATABUF];
	char descriptive_type[MAXDATABUF];
	char destination[MAXDATABUF];
	char disposition[MAXDATABUF];
	char division[MAXDATABUF];
	char document_number[MAXDATABUF];
	char editor[MAXDATABUF];
	char forward_to[MAXDATABUF];
	char group[MAXDATABUF];
	char language[MAXDATABUF];
	char mail_stop[MAXDATABUF];
	char matter[MAXDATABUF];
	char office[MAXDATABUF];
	char project[MAXDATABUF];
	char publisher[MAXDATABUF];
	char purpose[MAXDATABUF];
	char received_from[MAXDATABUF];
	char recorded_by[MAXDATABUF];
	char recorded_date[MAXDATABUF];
	char reference[MAXDATABUF];
	char revision_date[MAXDATABUF];
	char revision_notes[MAXDATABUF];
	char section[MAXDATABUF];
	char security[MAXDATABUF];
	char source[MAXDATABUF];
	char status[MAXDATABUF];
	char telephone_number[MAXDATABUF];
	char typist[MAXDATABUF];
	char version_date[MAXDATABUF];
	char version_notes[MAXDATABUF];
	char version_number[MAXDATABUF];
} DMC_PROPERTY;


#define FORMATNAME		128
#define	SUBFORMAT		128
#define COUNTRYNAME		32

/* File Information Defination */
typedef struct {
	char	DocFormat[FORMATNAME];
	char	DocSubFormat[SUBFORMAT];
	char	DocCountry[COUNTRYNAME];
	int		ProtectCode;
	int		FileType;
} DMC_FILEINFO, *LPDMC_FILEINFO;

/***
	Error code definitions
 ***/

#define SystemError				11
#define MemoryNotEnough			12
#define UserAbort				13

/* Physical file I/O errors */
#define FileNotFound			21
#define FileCantOpen			22
#define FileCantCreate			23
#define FileCantWrite			24
#define FileCantRead			25
#define FileCantDelete			26

#define FilePathTooLong			27

/* Interface function errors */
#define DllLoadFailed			1001
#define DllFuncCantFound		1002
#define CantInitialize			1003
#define LicenseFileNotFound		1004

/* File is not supported */
#define CantDetectFile			2001
// Xy~XCB݊̂߁A~XXŷ̂cĂB
// 2010/04/16 by show
#define NotSupported			2002
#define NotSuppoted	NotSupported
#define TimeOut					2003
#define LanguageNotSupported	2004

/* Can't extract text */
#define OtherProblems			3000
#define ProtectedByPassword		3001
#define InvalidFile				3002
#define NoTextStringFound		3003
#define StoppedByOle			3004
#define FileLengthOver			3005
#define MaxLoopCounts		3006
#define CompressDateUncompress 3007

/* OLE */
#define OleCantDetectFile		4000
// Xy~XCB݊̂߁A~XXŷ̂cĂB
// ̃o[WAbvMRł͍폜B
// 2010/04/16 by show
#define OleNotSupported			4001
#define OleNotSuppoted	OleNotSupported
#define OleProtectedBypassWord	4002
#define OleInvalidFile			4003
#define OleNoTextStringFound	4004
#define OleOutOfLimit			4005
#define InsertFileOutOfLimit			4006
// Xy~XCB݊̂߁A~XXŷ̂cĂB
// ̃o[WAbvMRł͍폜B
// 2010/04/16 by show
#define InsertFileNotSupported	4007
#define InsertFileNotSuppoted	InsertFileNotSupported
#define InsertFileNoTextStringFound			4008

/* PWD */
#define ProtectedByPassWordPDF	5000
#define WrongPassWord			5001
// Xy~XCB݊̂߁A~XXŷ̂cĂB
// ̃o[WAbvMRł͍폜B
// 2010/04/16 by show
#define PWDfileNotSupported		5002
#define PWDfileNotSuppoted	PWDfileNotSupported
#define ProtectedByOwnerPassWordPDF		5003

#define CompressedFileCantDetect        6000
// Xy~XCB݊̂߁A~XXŷ̂cĂB
// ̃o[WAbvMRł͍폜B
// 2010/04/16 by show
#define CompressedFileNotSupported		6001
#define CompressedFileNotSuppoted	CompressedFileNotSupported
#define CompressedFileNoTextStringFound	6002
#define CompressedFileInvalidfile		6003
#define CompressedFileByPassWord		6004
#define CompressedFileOutOfLimit		6005
#define StoppedByCompressedFile 		6006

/***
	Interface function
 ***/

#if defined( _WINDOWS) || defined(_WIN32) || defined(WIN32)
	#if defined(DMC_TXIF_EXPORTS)
		#define DMC_TXIF_EXPORT __declspec(dllexport)
	#else
		#define DMC_TXIF_EXPORT __declspec(dllimport)
	#endif
	#define DMC_API WINAPI
#else
	#if defined(DMC_TXIF_EXPORTS)
		#define DMC_TXIF_EXPORT  
	#else
		#define DMC_TXIF_EXPORT  
	#endif
	#define DMC_API 
#endif

typedef struct {
	int     LevNum;
	Byte	DtctResult[256];
	DWord	ErrCode;
} LDDMC_OLEERR;

typedef BOOL (*DMC_OLEERR_CALLBACK)(LDDMC_OLEERR* OleErr);

DMC_TXIF_EXPORT INT  DMC_GetFileInfo_V5(Byte* Appfile, DMC_FILEINFO* FileInfo, DMC_TEXTINFO_V5* TextInfo);
DMC_TXIF_EXPORT INT  DMC_GetProperty_V5(Byte* Appfile, DMC_TEXTINFO_V5* TextInfo, DMC_PROPERTY* Property);
DMC_TXIF_EXPORT INT  DMC_GetText_V5(Byte* Appfile, Byte* Txtfile, DMC_TEXTINFO_V5* TextInfo, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPageText_V5(Byte* Appfile, Byte* Txtfile, DMC_TEXTINFO_V5* TextInfo, int* Pages, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdText_V5(Byte* Appfile, Byte* Txtfile, DMC_TEXTINFO_V5* TextInfo, Byte* Password, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdPageText_V5(Byte* Appfile, Byte* Txtfile, DMC_TEXTINFO_V5* TextInfo, int* Pages, Byte* Password, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdProperty_V5(Byte* Appfile, DMC_TEXTINFO_V5* TextInfo, DMC_PROPERTY* Property, Byte* Password);

#ifdef DMC_WIN
DMC_TXIF_EXPORT INT  DMC_GetFileInfo_V5W(Word* Appfile, DMC_FILEINFO* FileInfo, DMC_TEXTINFO_V5* TextInfo);
DMC_TXIF_EXPORT INT  DMC_GetProperty_V5W(Word* Appfile, DMC_TEXTINFO_V5* TextInfo, DMC_PROPERTY* Property);
DMC_TXIF_EXPORT INT  DMC_GetText_V5W(Word* Appfile, Word* Txtfile, DMC_TEXTINFO_V5* TextInfo, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPageText_V5W(Word* Appfile, Word* Txtfile, DMC_TEXTINFO_V5* TextInfo, int* Pages, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdText_V5W(Word* Appfile, Word* Txtfile, DMC_TEXTINFO_V5* TextInfo, Byte* Password, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdPageText_V5W(Word* Appfile, Word* Txtfile, DMC_TEXTINFO_V5* TextInfo, int* Pages, Byte* Password, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdProperty_V5W(Word* Appfile, DMC_TEXTINFO_V5* TextInfo, DMC_PROPERTY* Property, Byte* Password);
#endif

DMC_TXIF_EXPORT INT  DMC_GetFileInfo_V4(Byte* Appfile, DMC_FILEINFO* FileInfo);
DMC_TXIF_EXPORT INT  DMC_GetProperty_V4(Byte* Appfile, DMC_TEXTINFO_V4* TextInfo, DMC_PROPERTY* Property);
DMC_TXIF_EXPORT INT  DMC_GetText_V4(Byte* Appfile, Byte* Txtfile, DMC_TEXTINFO_V4* TextInfo, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPageText_V4(Byte* Appfile, Byte* Txtfile, DMC_TEXTINFO_V4* TextInfo, int* Pages, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdText_V4(Byte* Appfile, Byte* Txtfile, DMC_TEXTINFO_V4* TextInfo, Byte* Password, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdPageText_V4(Byte* Appfile, Byte* Txtfile, DMC_TEXTINFO_V4* TextInfo, int* Pages, Byte* Password, DMC_OLEERR_CALLBACK pFuncOleErr);
DMC_TXIF_EXPORT INT  DMC_GetPwdProperty_V4(Byte* Appfile, DMC_TEXTINFO_V4* TextInfo, DMC_PROPERTY* Property, Byte* Password);
DMC_TXIF_EXPORT void DMC_GetVersionString(char *str, int maxlen);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif/* _TEXT_OEM_H_ */

